/*
 * ONF website ZMI extensions
 */

/* globals L, PyAMS_GIS */

(function($, globals) {

	'use strict';

	var MyAMS = globals.MyAMS;

	var ONF_website = {

		/**
		 * TinyMCE editor configuration
		 */
		TinyMCE: {

			initEditor: function (settings) {
				settings = PyAMS_content.TinyMCE.initEditor.call(this, settings);
				settings.menubar = 'file edit insert view table tools help';
				if (settings.toolbar1) {
					settings.toolbar1 = "undo redo | pastetext | header-h3 header-h4 | bold italic superscript | " +
										"alignleft aligncenter alignright | bullist numlist outdent indent";
				}
				return settings;
			}
		},


		/**
		 * Location management
		 */

		location: {

			/* Move location map marker to given position on filter selection */
			moveMapMarkerTo: function(event, options) {
				if (event.added) {
					var source = $(this);
					var map = source.parents('.map-header')
									.siblings('.map');
					var fieldname = map.data('map-leaflet-fieldname');
					var projection = $('select[name="' + fieldname + '.widgets.projection:list"]');
					MyAMS.jsonrpc.post('getLocationCoords', {
											source: event.added,
											to_srid: projection.val()
									   }, {
											url: '/api/onf/json'
									   }, function(data) {
											var result = data.result;
											PyAMS_GIS.position.moveMarkerTo(map, result.position, result.srid);
											var leafmap = map.data('leafmap');
											var layer = map.data('json-layer');
											if (layer !== undefined) {
												layer.remove();
											}
											var style = {
												color: '#dd0000',
												weight: 3,
												opacity: 0.7
											};
											style = $.extend({}, style, result.style);
											layer = L.geoJSON(result.geometry, {
												style: style
											});
											layer.addTo(leafmap);
											map.data('json-layer', layer);
											leafmap.fitBounds(layer.getBounds());
											var area = map.data('area');
											if (area) {
												area.editing.disable();
												area.setBounds(layer.getBounds());
												area.editing.enable();
												leafmap.fire(L.Draw.Event.EDITMOVE, {layer: area});
											}
									   });
				}
			}
		},


		/**
		 * Forests baseline management
		 */
		forest: {

			resetBaselineForm: function() {
				var target = $('#forest-user-baseline-helper');
				MyAMS.skin.cleanContainer(target);
				target.empty();
			},

			acceptProposedBaseline: function(evt) {
				var button = $(evt.target),
					form = button.parents('form'),
					draft = $(`#form-widgets-baseline_draft .html_content`, form).html(),
					target = tinymce.get('form-widgets-fr-baseline_published');
				if (target !== null) {
					target.setContent(draft);
				}
			},

			resetGalleryForm: function() {
				var target = $('#forest-user-gallery-helper');
				MyAMS.skin.cleanContainer(target);
				target.empty();
			},

			dragMediaFromDraft: function(event, ui) {
				var draggable = $(ui.draggable);
				if (draggable.data('dragging')) {
					return;
				}
				draggable.data('dragging', true);
				var gallery = $('#gallery_published'),
					source = $(ui.draggable).data('ams-element-name');
				MyAMS.ajax.post(`${gallery.data('ams-location')}/copy-from-draft.json`, {
					source: source
				}, function(result) {
					result = result.result;
					draggable.draggable('destroy');
					draggable.removeClass('draggable')
						.removeClassPrefix('ui-draggable')
						.removeClass('media-draft')
						.removeAttr('data-ams-draggable-connect-sortable')
						.removeAttr('data-ams-draggable-containment')
						.removeAttr('data-ams-draggable-revert')
						.attr('data-ams-element-name', result.name)
						.removeData();
					$('.fancyimg', draggable).attr('href', result.href);
					$('img', draggable).attr('src', result.src);
					$('a[data-toggle="modal"]', draggable).attr('data-ams-url',
						`${gallery.data('ams-location')}/${result.name}/gallery-file-properties.html`)
						.removeData();
					var ids = $('.media', gallery).listattr('data-ams-element-name');
					MyAMS.ajax.post(`${gallery.data('ams-location')}/set-medias-order.json`, {
						medias: JSON.stringify(ids)
					}, function() {
						draggable.removeData('dragging');
					});
				});
			},

			setMediasOrder: function(event, ui) {
				var draggable = $(ui.item);
				if (draggable.data('dragging')) {
					return;
				}
				var gallery = ui.item.parents('.gallery');
				var ids = $('.media', gallery).listattr('data-ams-element-name');
				MyAMS.ajax.post(`${gallery.data('ams-location')}/set-medias-order.json`, {
					medias: JSON.stringify(ids)
				});
			}
		}
	};


	/**
	 * Location map listener to 'marker.changed' event
	 * If marker position is overriding a forest, get forest geometry and display it
	 * as GeoJSON, and update filter area with selected forest name
	 */
	$(document).on('marker.changed', function(event, map, position) {
		map = $(map);
		var mapdata = map.data();
		var fieldname = mapdata.mapLeafletFieldname;
		var srid = $('select[name="' + fieldname + '.widgets.projection:list"]');
		MyAMS.jsonrpc.post('getForestAt', {
			position: position,
			srid: srid.val()
		}, {
			url: '/api/onf/json'
		}, function(data) {
			// Reset map layer
			var leafmap = mapdata.leafmap;
			var layer = mapdata.jsonLayer;
			if (layer !== undefined) {
				layer.remove();
			}
			var filter = $('input[name="pyams_gis.map.header_location"]');
			var result = data.result;
			if (result) {
				// Update location filter
				filter.select2('data', result);
				// Update map with selected geometry
				layer = L.geoJSON(result.geometry, {
					style: {
						color: '#00dd00',
						weight: 3,
						opacity: 0.7
					}
				});
				layer.addTo(leafmap);
				map.data('json-layer', layer);
			} else {
				filter.select2('data', null);
			}
		});
	});


	/**
	 * Location map listener to 'marker.closed.position' event
	 * If marker selection dialog is closed with 'OK' button, if filter is not empty
	 * and if there is no already selected forest, update forests selection area with
	 * filter data
	 */
	$(document).on('marker.closed.position', function(event, options) {
		var filter = $('input[name="pyams_gis.map.header_location"]');
		if (filter.val()) {
			var forests = $('input[name="form.widgets.forests"]');
			if (forests && !forests.val()) {
				forests.select2('data', filter.select2('data'));
			}
		}
	});

	/**
	 * Location map listener to 'marker.cleared.*' event
	 * Reset filter on position or area reset
	 */
	$(document).on('marker.cleared.position marker.cleared.area', function(event) {
		var filter = $('input[name="pyams_gis.map.header_location"]');
		filter.select2('data', null);
	});

	globals.ONF_website = ONF_website;

})(jQuery, this);
