#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.location import ILocation

from onf_website.component.hearing import IHearingInfo
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common.interfaces.types import IWfTypedSharedContent
from pyams_skin.interfaces.viewlet import IBreadcrumbs
from pyams_skin.viewlet.breadcrumb import BreadcrumbsAdapter as BaseBreadcrumbsAdapter, \
    BreadcrumbsContentProvider
from pyams_template.template import override_template
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.url import DISPLAY_CONTEXT


@adapter_config(context=(ILocation, IONFBaseLayer, Interface),
                provides=IBreadcrumbs)
@adapter_config(context=(IWfTypedSharedContent, IONFBaseLayer, Interface),
                provides=IBreadcrumbs)
class BreadcrumbsAdapter(BaseBreadcrumbsAdapter):
    """Breadcrumbs adapter

    Use base breadcrumbs adapter, don't use PyAMS custom adapter
    which is using display context as breadcrumbs base.
    """

    @property
    def items(self):
        source = self.request.annotations.get(DISPLAY_CONTEXT)
        if source is None:
            hearing = IHearingInfo(self.context, None)
            if hearing is not None:
                source = hearing.get_source_folder()
                if source is None:
                    source = hearing.get_source_site()
        if source is None:
            if IWfTypedSharedContent.providedBy(self.context):
                data_type = self.context.get_data_type()
                if data_type is not None:
                    source = data_type.get_source_folder()
        if source is None:
            source = self.request.context
        yield from self.get_items(source)


override_template(context=BreadcrumbsContentProvider, layer=IONFBaseLayer,
                  template='breadcrumbs.pt')
