#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public.interfaces import IBodyClass, IMainClass, PYAMS_BODY_CLASS_KEY, \
    PYAMS_MAIN_CLASS_KEY
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension


__docformat__ = 'restructuredtext'


@adapter_config(name='body_class',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class BodyClassTALESExtension(ContextRequestViewAdapter):
    """tales:body_class TALES extension"""

    def render(self):
        request = self.request
        body_class = request.annotations.get(PYAMS_BODY_CLASS_KEY)
        if body_class is None:
            body_class = request.registry.queryMultiAdapter((request.context, request),
                                                            IBodyClass, default='')
        return body_class


@adapter_config(name='main_class',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class MainClassTALESExtension(ContextRequestViewAdapter):
    """tales:main_class TALES extension"""

    def render(self):
        request = self.request
        main_class = request.annotations.get(PYAMS_MAIN_CLASS_KEY)
        if main_class is None:
            main_class = request.registry.queryMultiAdapter((request.context, request),
                                                            IMainClass, default='')
        return main_class
