#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.skin.public.satellite.live import IONFLiveLayer
from onf_website.skin.public.viewlet.banner import SiteRootBanner
from pyams_content.shared.site import IWfSiteTopic
from pyams_content.shared.topic import IWfTopic
from pyams_template.template import template_config
from pyams_viewlet.viewlet import contentprovider_config


@contentprovider_config(name='pyams.banner',
                        context=IWfTopic, layer=IONFLiveLayer, view=Interface)
@contentprovider_config(name='pyams.banner',
                        context=IWfSiteTopic, layer=IONFLiveLayer, view=Interface)
@template_config(template='templates/topic-banner.pt', layer=IONFLiveLayer)
class LiveTopicBanner(SiteRootBanner):
    """Live skin topic banner"""
