#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public import onf_live_skin
from onf_website.skin.public.layer import IONFSatelliteLayer
from pyams_skin.interfaces import ISkin
from pyams_skin.interfaces.resources import IResources
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.registry import utility_config


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFLiveLayer(IONFSatelliteLayer):
    """ONF live skin layer"""


@utility_config(name='ONF live skin', provides=ISkin)
class ONFLiveSkin:
    """ONF live skin"""

    label = _("ONF: live forest skin")
    layer = IONFLiveLayer


@adapter_config(context=(Interface, IONFLiveLayer, Interface),
                provides=IResources)
class ONFLiveLayerResourcesAdapter(ContextRequestViewAdapter):
    """Live layer resources adapter"""

    resources = (onf_live_skin,)
