(function($) {

	$('.owl-carousel').each(function() {

		// parse responsive itmes Object Literal stored in
		// data-owl-carousel-responsive-items attribute
		// or return default
		var responsiveItems = function(dataStr, nbItems) {
			if (dataStr === undefined) {
				return {
					0: {items: 1},
					400: {items: Math.min(nbItems, 2)},
					667: {items: Math.min(nbItems, 3)}
				};
			} else {
				return JSON.parse(JSON.stringify(dataStr));
			}
		};

    // var resetIframes = function () {
    //   console.log('je passe');
    //   jQuery('.linkedin-card').removeClass('clickable');
    // };

		var owl = $(this),
			data = owl.data(),
			nbItems = $(data.owlCarouselItemSelector || '.item', this).length,
			respItems = responsiveItems(data.owlCarouselResponsiveItems, nbItems),
			owlOptions = {
				loop: data.owlCarouselLoop === undefined ? false : data.owlCarouselLoop,
				margin: data.owlCarouselMargin || 30,
				dots: data.owlCarouselDots === undefined ? true : data.owlCarouselDots,
				nav: data.owlCarouselNav === undefined ? true : data.owlCarouselNav,
				navText: [
					'<span aria-label="' + data.owlCarouselPrevLabel + '" class="owl-prev-arrow"></span>',
					'<span aria-label="' + data.owlCarouselNextLabel + '" class="owl-next-arrow"></span>'
				],
				responsiveClass: true,
				responsive: respItems,
				autoWidth: data.owlCarouselAutoWidth === undefined ? false : data.owlCarouselAutoWidth,
				autoHeight: data.owlCarouselAutoHeight === undefined ? false : data.owlCarouselAutoHeight,
				mouseWheel: data.owlCarouselMouseWheel === undefined ? false : data.owlCarouselMouseWheel
			}; // onChange: resetIframes

		// check if mobile only carousel on load
		if (data.owlCarouselMobileOnly === undefined) {

			owl.owlCarousel(owlOptions);

			if (data.owlCarouselMouseWheel) {

				owl.on('mousewheel', '.owl-stage', function (e) {
					var curr = $(this);
					if (e.deltaY > 0) {
						curr.trigger('next.owl');
					} else {
						curr.trigger('prev.owl');
					}
					e.preventDefault();
				});
			}

		} else {

			// check if screen size is mobile
			if ($(window).width() < 768) {
				var owlActive = owl.owlCarousel(owlOptions);
			} else {
				owl.addClass('off');
			}

			// check if mobile only carousel on window resize
			$(window).resize(function() {
				if ($(window).width() < 768) {
					if (owl.hasClass('off')) {
						var owlActive = owl.owlCarousel(owlOptions);
						owl.removeClass('off');
					}
				} else {
					if (!owl.hasClass('off')) {
						owl.addClass('off').trigger('destroy.owl.carousel');
						owl.find('.owl-stage-outer').children(':eq(0)').unwrap();
					}
				}
			});

		}
	});

}(jQuery));
