(function ($, viewport) {

  var mql = window.matchMedia('(min-width: 1052px)');

  var tl = gsap.timeline({ paused: true });

  var homeBanner2022 = document.getElementById('homeBanner2022');

  var tempsFort = document.getElementById('tempsFort');
  if (tempsFort) {
    var tempsFortButton = tempsFort.querySelector('.temps-fort__button');
    var tempsFortTitle = tempsFort.querySelector('.temps-fort__title');
    var tempsFortArrow = tempsFort.querySelector('.temps-fort__arrow');
    var tempsFortBg = tempsFort.querySelector('.temps-fort__img');
    var tempsFortContent = tempsFort.querySelector('.temps-fort__content');


    var fxEnter = function () {
      homeBanner2022.classList.add('active');
      tl.play();
    }
    var fxLeave = function () {
      homeBanner2022.classList.remove('active');
      tl.reverse();
    }


    var handleMatches = function (matches) {

      // Kill old animation and clear out old styles
      if (oldAnim) {

        oldAnim.kill();

        gsap.set(tempsFort, {
          clearProps: true
        });
        gsap.set(tempsFortBg, {
          clearProps: true
        });
        gsap.set(tempsFortContent, {
          clearProps: true
        });
        gsap.set(tempsFortArrow, {
          clearProps: true
        });
        gsap.set(tempsFortTitle, {
          clearProps: true
        });

        tempsFort.removeEventListener('mouseenter', fxEnter, false);
        tempsFort.removeEventListener('mouseleave', fxLeave, false);

      }

      if (matches) {

        oldAnim = tl
            .add('start')
            .to(tempsFort, {
              width: '620px',
              height: '520px',
              paddingRight: '100px',
              bottom: '-70px',
              right: '50px',
              ease: 'back.out(1.025)'
            }, 'start')
            // .to(tempsFortButton, {
            //   borderColor: 'rgba(255, 255, 255, .5)',
            // }, 'start')
            .to(tempsFortBg, {
              opacity: 0,
            }, 'start')
            .to(tempsFortTitle, {
              opacity: 0,
              transform: 'scale(.1)',
            }, 'start')
            .to(tempsFortContent, {
              opacity: 1,
              transform: 'translate(-50%, -50%) scale(1)',
              delay: 0.2,
            }, 'start');

        // tl.play();

        tempsFort.addEventListener('mouseenter', fxEnter, false);
        tempsFort.addEventListener('mouseleave', fxLeave, false);

      } else {

        if (oldAnim) {
          oldAnim.kill();
        }

        gsap.set(tempsFort, {
          clearProps: true
        });

        // debugger;

        tempsFort.removeEventListener('mouseenter', fxEnter, false);
        tempsFort.removeEventListener('mouseleave', fxLeave, false);

      }
    }

    var oldAnim;
    mql.addEventListener('change', function (e) {
      handleMatches(e.matches)
    });
    handleMatches(mql.matches);

    $(window).resize(
      viewport.changed(function() {
        if (viewport.is('<md')) {
          tempsFort.removeEventListener('mouseenter', fxEnter, false);
          tempsFort.removeEventListener('mouseleave', fxLeave, false);
        }
      }, 150)
    );

  }

})(jQuery, ResponsiveBootstrapToolkit);
