#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.features.header.skin import ONFDefaultHeaderRenderer
from onf_website.skin.public.internal import IONFInternalLayer
from pyams_content.root.interfaces import ISiteRoot
from pyams_default_theme.features.header.skin import IHeaderClass, INavigationClass
from pyams_template.template import override_template
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


#
# Internal skin header
#

override_template(context=ONFDefaultHeaderRenderer, layer=IONFInternalLayer,
                  template='templates/internal-header.pt')


@adapter_config(context=(Interface, IONFInternalLayer), provides=IHeaderClass)
def internal_site_header_class_adapter(context, request):
    """Generic header class adapter"""
    return 'wrapper-header--internal'


@adapter_config(context=(Interface, IONFInternalLayer), provides=INavigationClass)
def internal_site_navigation_class_adapter(context, request):
    """Generic header class adapter"""
    return 'wrapper-nav--internal'


@adapter_config(context=(ISiteRoot, IONFInternalLayer), provides=IHeaderClass)
def site_root_header_class_adapter(context, request):
    """Site root header class adapter"""
    return ''
