# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form.field import Fields

from onf_website.shared.site import ISiteManagerUniverseInfo
from pyams_content.shared.site.interfaces import ISiteManager
from pyams_content.shared.site.zmi.manager import SiteManagerPropertiesEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.layer import IAdminLayer

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='universe',
                required=(ISiteManager, IAdminLayer, SiteManagerPropertiesEditForm),
                provides=IInnerSubForm)
class SiteManagerUniverseEditForm(InnerAdminEditForm):
    """Site manager universe edit subform"""
    
    prefix = 'universe_form.'
    
    legend = _("Universe")
    
    fields = Fields(ISiteManagerUniverseInfo)
    
    weight = 2
