# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface
from zope.schema import Choice

__docformat__ = 'restructuredtext'

from onf_website import _


SITE_MANAGER_UNIVERSE_KEY = 'onf_website.universe'


class ISiteManagerUniverseInfo(Interface):
    """Site manager universe information interface"""
    
    universe = Choice(title=_("Associated universe"),
                      description=_("Select the universe associated with this site"),
                      vocabulary='ONF universe',
                      required=False)
