#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field
from zope.interface import Interface, implementer

from onf_website.shared.service.interfaces import IServiceManager, IWfService, IWfServiceInfo
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IWidgetForm
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle, IInnerPage
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IContentManagementMenu, IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

from onf_website import _


@adapter_config(context=(IWfService, IContentManagementMenu), provides=IMenuHeader)
class ServiceContentMenuHeader(ContextRequestAdapter):
    """Service content menu header adapter"""

    header = _("This service delivery")


@adapter_config(context=(IWfService, IPyAMSLayer, Interface), provides=IContentTitle)
class ServiceTitleAdapter(ContextRequestViewAdapter):
    """Service title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Service delivery « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=IServiceManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class ServiceAddAction(ToolbarAction):
    """Service adding action"""

    label = _("Add service delivery")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=IServiceManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json', context=IServiceManager, layer=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, base=SharedContentAJAXAddForm)
class ServiceAddForm(SharedContentAddForm):
    """Service add form"""

    legend = _("Add service delivery")


#
# Custom fields properties edit form
#

@viewlet_config(name='custom-properties.menu', context=IWfService, layer=IPyAMSLayer,
                manager=IPropertiesMenu, permission=MANAGE_CONTENT_PERMISSION, weight=20)
class CustomPropertiesMenu(MenuItem):
    """Custom properties menu"""

    label = _("Specific properties")
    icon_class = 'fa-paperclip'
    url = '#custom-properties.html'


@pagelet_config(name='custom-properties.html', context=IWfService, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='custom-properties.json', context=IWfService, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class ServiceCustomPropertiesEditForm(AdminEditForm):
    """Service custom properties edit form"""

    legend = _("Service delivery specific properties")

    fields = field.Fields(IWfServiceInfo)

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        if 'client_wish' in self.widgets:
            self.widgets['client_wish'].widget_css_class = 'input height-200'
        if 'provider_assets' in self.widgets:
            self.widgets['provider_assets'].widget_css_class = 'input height-200'
