#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.paragraph import IParagraphContainer
from pyams_content.component.paragraph.interfaces.html import HTML_PARAGRAPH_TYPE
from pyams_content.shared.resource import IWfResource
from pyams_default_theme.features.search.portlet import ISearchResultHeader, ISearchResultRenderer, \
    WfSharedContentSearchResultRenderer
from pyams_default_theme.interfaces import ISearchResultsPanelView, ISearchResultsView
from pyams_i18n.interfaces import II18n
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.text import text_to_html


@adapter_config(context=(IWfResource, IONFBaseLayer, ISearchResultsView),
                provides=ISearchResultHeader)
def resource_search_result_header_adapter(context, request, view):
    """Resource search result header adapter"""
    header = II18n(context).query_attribute('header', request=request)
    if header:
        return text_to_html(header)
    for paragraph in IParagraphContainer(context).get_visible_paragraphs(
            factories=(HTML_PARAGRAPH_TYPE,)):
        body = II18n(paragraph).query_attribute('body')
        if body:
            return text_to_html(body, 'remove_tags')
    return ''


@adapter_config(context=(IWfResource, IONFBaseLayer, ISearchResultsView),
                provides=ISearchResultRenderer)
@template_config(template='templates/search-result.pt', layer=IONFBaseLayer)
class WfResourceSearchResultRenderer(WfSharedContentSearchResultRenderer):
    """Resource search result renderer"""


@adapter_config(context=(IWfResource, IONFBaseLayer, ISearchResultsPanelView),
                provides=ISearchResultRenderer)
@template_config(template='templates/search-panel.pt', layer=IONFBaseLayer)
class WfResourceSearchResultPanelRenderer(WfSharedContentSearchResultRenderer):
    """Resource search result panel renderer"""
