#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.reserve.interfaces import IReserve, IWfReserve, IWfReserveFactory, \
    RESERVE_CONTENT_NAME, RESERVE_CONTENT_TYPE
from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'


@implementer(IWfReserve, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfReserve(WfSharedContent, WfTypedSharedContentMixin):
    """Reserve class"""

    content_type = RESERVE_CONTENT_TYPE
    content_name = RESERVE_CONTENT_NAME

    references = FieldProperty(IWfReserve['references'])

register_content_type(WfReserve)


@provider(IWfReserveFactory)
@implementer(IReserve)
class Reserve(SharedContent):
    """Workflow managed reserve"""


@adapter_config(context=IWfReserveFactory, provides=IWfSharedContentFactory)
def report_content_factory(context):
    return WfReserve
