#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.shared.common.interfaces import ISharedContent, ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_sequence.interfaces import IInternalReferencesList


__docformat__ = 'restructuredtext'

from onf_website import _


REPORT_CONTENT_TYPE = 'report'
REPORT_CONTENT_NAME = _("Report")


class IReportManager(ISharedToolPortalContext):
    """Report manager interface"""


class IReportManagerFactory(Interface):
    """Report manager factory interface"""


class IWfReport(IWfSharedContentPortalContext, IInternalReferencesList):
    """Report interface"""


class IWfReportFactory(Interface):
    """Report factory interface"""


class IReport(ISharedContent):
    """Workflow managed report interface"""
