
"""ONF_WebSite.shared.planning.zmi.manager module

"""

from z3c.form import field

from onf_website.shared.planning.interfaces import IPlanningManager, IPlanningManagerInfo
from onf_website.shared.planning.zmi.widget import PlanningManagerTemplatesSelectWidgetFactory
from pyams_content.component.illustration import IIllustration
from pyams_content.component.illustration.zmi import IllustrationPropertiesInnerEditForm
from pyams_content.component.theme.zmi import TagsMenu
from pyams_content.interfaces import MANAGE_TOOL_PERMISSION
from pyams_content.shared.common.zmi.manager import SharedToolPropertiesEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.interfaces import IPropertiesEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='dom-illustration',
                context=(IPlanningManager, IPyAMSLayer, IPropertiesEditForm),
                provides=IInnerSubForm)
class DOMIllustrationPropertiesInnerEditForm(IllustrationPropertiesInnerEditForm):
    """DOM illustration properties inner edit form"""

    prefix = 'dom_illustration_form.'

    legend = _("DOM illustration")
    weight = 11

    def getContent(self):
        registry = self.request.registry
        return registry.queryAdapter(self.context, IIllustration, name='dom')


@adapter_config(name='owner-settings',
                context=(IPlanningManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class PlanningManagerOwnerSettingsEditForm(InnerAdminEditForm):
    """Planning manager owner settings edit form"""

    prefix = 'owner_properties.'

    legend = _("Baseline settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IPlanningManagerInfo).select('default_owner', 'default_header')

    weight = 15


@adapter_config(name='hearing-settings',
                context=(IPlanningManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class PlanningManagerHearingSettingsEditForm(InnerAdminEditForm):
    """Planning manager hearing settings edit form"""

    prefix = 'hearing_properties.'

    legend = _("Hearing settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IPlanningManagerInfo).select('default_hearing_source',
                                                       'default_source_folder')

    weight = 20


@adapter_config(name='template-settings',
                context=(IPlanningManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class PlanningManagerTemplateSettingsEditForm(InnerAdminEditForm):
    """Planning manager template settings edit form"""

    prefix = 'template_properties.'

    legend = _("Template settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IPlanningManagerInfo).select('templates')
    fields['templates'].widgetFactory = PlanningManagerTemplatesSelectWidgetFactory

    weight = 30


@adapter_config(name='message-settings',
                context=(IPlanningManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class PlanningManagerMessageSettingsEditForm(InnerAdminEditForm):
    """Planning manager message settings edit form"""

    prefix = 'message_properties.'

    legend = _("Message settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IPlanningManagerInfo).select('msg_expired', 'msg_expired_3y',
                                                       'msg_no_doc', 'msg_missing_docs')

    weight = 40


@viewlet_config(name='tags.menu',
                context=IPlanningManager, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=350,
                permission=MANAGE_TOOL_PERMISSION)
class PlanningManagerTagsMenu(TagsMenu):
    """Planning manager tags menu"""

    label = _("Default tags...")
