
"""PyAMS_*** module

"""

from zope.interface import Interface

from onf_website.shared.common.skin.head import BaseHeaderPortletRenderer
from onf_website.shared.planning import FakePlanning, IPlanningManager, IWfPlanning, WfPlanning
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.illustration import IIllustration, ILinkIllustration
from pyams_content.component.illustration.portlet.interfaces import IIllustrationPortletContent
from pyams_content.features.renderer.interfaces import HIDDEN_RENDERER_NAME
from pyams_content.shared.common.portlet.interfaces import ISharedContentHeaderPortletSettings
from pyams_default_theme.interfaces import IContentHeader, IContentNavigationIllustration
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import get_utility, query_utility


__docformat__ = 'restructuredtext'

from onf_website import _


#
# Custom planning navigation illustration adapter
#

@adapter_config(context=(FakePlanning, IONFBaseLayer),
                provides=IContentNavigationIllustration)
def fake_planning_illustration_factory(context, request):
    """Fake planning illustration factory"""
    manager = query_utility(IPlanningManager)
    if manager is None:
        return None
    refs = context.planning_refs
    if not refs:
        return None
    planning, info_planning = refs[0]
    if planning.departement_situation and planning.departement_situation.startswith('97'):
        adapter_name = 'dom'
    else:
        adapter_name = ''
    illustration = request.registry.queryAdapter(manager, IIllustration,
                                                 name=adapter_name)
    if adapter_name and \
        ((illustration is None) or
         (not illustration.has_data()) or
         (illustration.renderer == HIDDEN_RENDERER_NAME)):
        illustration = request.registry.queryAdapter(manager, IIllustration, name='')
    return illustration


@adapter_config(context=(WfPlanning, IONFBaseLayer),
                provides=IContentNavigationIllustration)
def planning_illustration_factory(context, request):
    """Planning illustration factory"""
    illustration = ILinkIllustration(context, None)
    if (illustration is not None) and illustration.has_data():
        return illustration
    illustration = IIllustration(context, None)
    if (illustration is not None) and \
            illustration.has_data() and \
            (illustration.renderer != HIDDEN_RENDERER_NAME):
        return illustration
    return fake_planning_illustration_factory(context, request)


@adapter_config(context=(FakePlanning, IONFBaseLayer, Interface),
                provides=IIllustrationPortletContent)
def fake_planning_illustration_portlet_content(context, request, view):
    """Planning illustration portlet content"""
    return fake_planning_illustration_factory(context, request)


@adapter_config(context=(WfPlanning, IONFBaseLayer, Interface),
                provides=IIllustrationPortletContent)
def planning_illustration_portlet_content(context, request, view):
    """Planning illustration portlet content"""
    illustration = IIllustration(context, None)
    if (illustration is not None) and \
            illustration.has_data() and \
            (illustration.renderer != HIDDEN_RENDERER_NAME):
        return illustration
    return fake_planning_illustration_portlet_content(context, request, view)


@adapter_config(name='ONF::head-planning',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head-planning.pt', layer=IONFBaseLayer)
class PlanningHeaderPortletRenderer(BaseHeaderPortletRenderer):
    """Planning header portlet renderer"""

    label = _("ONF: Planning header")
    weight = 70

    def get_illustration(self):
        illustration = IIllustration(self.context, None)
        if (illustration is not None) and illustration.has_data():
            if illustration.renderer != HIDDEN_RENDERER_NAME:
                return illustration
        manager = query_utility(IPlanningManager)
        if manager is None:
            return None
        planning, info_planning = self.context.planning_refs[0]
        if planning.departement_situation and planning.departement_situation.startswith('97'):
            adapter_name = 'dom'
        else:
            adapter_name = ''
        illustration = self.request.registry.queryAdapter(manager, IIllustration,
                                                          name=adapter_name)
        if adapter_name and \
                ((illustration is None) or
                 (not illustration.has_data()) or
                 (illustration.renderer == HIDDEN_RENDERER_NAME)):
            illustration = self.request.registry.queryAdapter(manager, IIllustration,
                                                              name='')
        return illustration


@adapter_config(context=(IWfPlanning, IONFBaseLayer),
                provides=IContentHeader)
def planning_content_header(context, request):
    """Fake planning content header"""
    header = II18n(context).query_attribute('header', request=request)
    if not header:
        manager = get_utility(IPlanningManager)
        header = II18n(manager).query_attribute('default_header', request=request)
    return header
