#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from hypatia.catalog import CatalogQuery
from hypatia.interfaces import ICatalog
from hypatia.query import Eq
from zope.interface import Interface

from onf_website.shared.planning import PLANNING_CONTENT_TYPE
from onf_website.shared.planning.interfaces import IPlanningLinkPortletSettings
from pyams_catalog.query import CatalogResultSet
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer, IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.list import boolean_iter
from pyams_utils.registry import get_utility
from pyams_utils.url import absolute_url


__docformat__ = 'restructuredtext'

from onf_website import _


class PlanningLinkPortletRenderer(PortletRenderer):
    """Base planning link portlet renderer"""

    @property
    def planning_refs(self):
        return self.context.planning_refs

    @property
    def planning_attributes(self):
        if self.planning_refs:
            planning, info = self.planning_refs[-1]
            planning_id = planning.id_nat_amgt

            catalog = get_utility(ICatalog)
            params = Eq(catalog['content_type'], PLANNING_CONTENT_TYPE) & \
                Eq(catalog['plannings'], planning_id)
            has_results, results = boolean_iter(
                CatalogResultSet(CatalogQuery(catalog).query(params)))
            if has_results:
                planning_content = next(results)
                i18n = II18n(planning_content)
                return i18n.query_attribute('title', request=self.request), \
                       i18n.query_attribute('header', request=self.request)
            if info:
                return info.libelle or planning.nom_usage_amenagement, \
                       info.header or planning.type_amenagement
            return planning.nom_usage_amenagement, planning.type_amenagement

    def get_planning_link(self):
        if self.planning_refs:
            planning, info = self.planning_refs[-1]
            return '{}/+a/{}'.format(
                absolute_url(self.request.root, self.request),
                planning.id_nat_amgt
            )


#
# Planning link portlet textured renderer
#

@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IPlanningLinkPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/textured.pt', layer=IPyAMSUserLayer)
class PlanningLinkPortletTexturedRenderer(PlanningLinkPortletRenderer):
    """Planning Link portlet textured renderer"""

    label = _("ONF: textured card")
    weight = 21
