#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.longread.interfaces import ILongRead, IWfLongRead, IWfLongReadFactory, \
    LONG_READ_CONTENT_NAME, LONG_READ_CONTENT_TYPE
from pyams_content.component.illustration.interfaces import IIllustrationTarget, \
    ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@implementer(IWfLongRead, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfLongRead(WfSharedContent, WfTypedSharedContentMixin):
    """Base long-read class"""

    content_type = LONG_READ_CONTENT_TYPE
    content_name = LONG_READ_CONTENT_NAME

    references = FieldProperty(IWfLongRead['references'])


register_content_type(WfLongRead)


@provider(IWfLongReadFactory)
@implementer(ILongRead)
class LongRead(SharedContent):
    """Workflow managed long-read class"""


@adapter_config(context=IWfLongReadFactory, provides=IWfSharedContentFactory)
def topic_content_factory(context):
    return WfLongRead
