#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from onf_website.skin.public import owl_carousel_init
from pyams_content.features.renderer import IContentRenderer
from pyams_content.shared.logo.interfaces import ILogosParagraph
from pyams_default_theme.shared.logo import LogosParagraphDefaultRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='default',
                context=(ILogosParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/logos-default.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/logos-title-left.pt', layer=IPyAMSLayer)
class ONFLogosParagraphDefaultRenderer(LogosParagraphDefaultRenderer):
    """Logos paragraph default renderer"""

    label = _("ONF Default logos renderer")
    weight = 10

    i18n_context_attrs = ('title',)

    resources = (owl_carousel_init,)


@adapter_config(name='logo-grey',
                context=(ILogosParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/logos-grey.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/logos-title-left-grey.pt', layer=IPyAMSLayer)
class ONFGreyLogoParagraphRenderer(LogosParagraphDefaultRenderer):
    """Logos paragraph grey carrousel renderer"""

    label = _("ONF Carousel of logos in grey renderer")
    weight = 15

    i18n_context_attrs = ('title',)

    resources = (owl_carousel_init,)


@adapter_config(name='logo-grid',
                context=(ILogosParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/logos-grid.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/logos-title-left-grid.pt', layer=IPyAMSLayer)
class ONFGridLogosParagraphRenderer(LogosParagraphDefaultRenderer):
    """Logos paragraph grid renderer"""

    label = _("ONF Logos grid")
    weight = 20

    i18n_context_attrs = ('title',)
