#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_default_theme.shared.common.interfaces import ICustomContentSpecificitiesRenderer
from onf_website.shared.interview.interfaces import IWfInterviewInfo, IWfInterview
from onf_website.skin.public import aside_sticky
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import ViewContentProvider


@adapter_config(context=(IWfInterview, IONFBaseLayer, Interface), provides=ICustomContentSpecificitiesRenderer)
@template_config(template='templates/specificities.pt', layer=IONFBaseLayer)
class InterviewSpecificitiesRenderer(ViewContentProvider):
    """Interview specificities renderer"""

    resources = (aside_sticky,)

    @property
    def interview_info(self):
        return IWfInterviewInfo(self.context)
