#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from onf_website import _


__docformat__ = 'restructuredtext'

from z3c.form import field
from zope.interface import implementer, Interface

from onf_website.shared.hunting import IHuntingCalendarInfo, IWfHuntingCalendar
from onf_website.shared.hunting.interfaces import IHuntingManager
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IWidgetForm
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle, IInnerPage
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm
from pyams_zmi.interfaces.menu import IContentManagementMenu, IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


@adapter_config(context=(IWfHuntingCalendar, IContentManagementMenu), 
                provides=IMenuHeader)
class HuntingCalendarContentMenuHeader(ContextRequestAdapter):
    """Hunting calendar content menu header adapter"""

    header = _("This calendar")


@adapter_config(context=(IWfHuntingCalendar, IPyAMSLayer, Interface),
                provides=IContentTitle)
class HuntingCalendarTitleAdapter(ContextRequestViewAdapter):
    """Hunting calendar title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Calendar « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action',
                context=IHuntingManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager,
                permission=CREATE_CONTENT_PERMISSION, weight=1)
class HuntingCalendarAddAction(ToolbarAction):
    """Hunting calendar adding action"""

    label = _("Add hunting calendar")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html',
                context=IHuntingManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json',
             context=IHuntingManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, base=SharedContentAJAXAddForm)
class HuntingCalendarAddForm(SharedContentAddForm):
    """Hunting calendar add form"""

    legend = _("Add hunting calendar")


#
# Custom fields properties edit form
#

@viewlet_config(name='custom-properties.menu',
                context=IWfHuntingCalendar, layer=IPyAMSLayer, manager=IPropertiesMenu,
                permission=MANAGE_CONTENT_PERMISSION, weight=20)
class HuntingCalendarCustomPropertiesMenu(MenuItem):
    """Custom properties menu"""

    label = _("Specific properties")
    icon_class = 'fa-paperclip'
    url = '#custom-properties.html'


@pagelet_config(name='custom-properties.html',
                context=IWfHuntingCalendar, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='custom-properties.json',
             context=IWfHuntingCalendar, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class HuntingCalendarCustomPropertiesEditForm(AdminEditForm):
    """Interview custom properties edit form"""

    legend = _("Calendar specific properties")

    fields = field.Fields(IHuntingCalendarInfo)
