# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.map.interfaces import have_gis
if have_gis:
    
    from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
    from z3c.form.field import Fields
    
    from onf_website.component.map.portlet.zmi import MapPortletDefaultRendererSettingsFormManager
    from onf_website.shared.hunting.skin.interfaces import IHuntingCalendarLocationMapPortletRendererSettings
    from pyams_form.group import NamedWidgetsGroup
    from pyams_form.interfaces.form import IFormManager
    from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
    from pyams_skin.layer import IPyAMSLayer
    from pyams_utils.adapter import adapter_config
    from pyams_zmi.form import AdminDialogEditForm
    
    from onf_website import _

    
    @adapter_config(required=(IHuntingCalendarLocationMapPortletRendererSettings, IPyAMSLayer,
                              PortletRendererPropertiesEditForm),
                    provides=IFormManager)
    class HuntingCalendarLocationMapPortletRendererSettingsFormManager(
            MapPortletDefaultRendererSettingsFormManager):
        """Hunting calendar location map portlet renderer settings form manager"""
        
        
        def getFields(self):
            fields = Fields(IHuntingCalendarLocationMapPortletRendererSettings).omit(
                    'use_default_map_configuration')
            fields['no_use_default_map_configuration'].widgetFactory = SingleCheckBoxFieldWidget
            fields['display_context_forests'].widgetFactory = SingleCheckBoxFieldWidget
            fields['display_content_link'].widgetFactory = SingleCheckBoxFieldWidget
            return fields

        def updateGroups(self):
            view = self.view
            view.add_group(NamedWidgetsGroup(view, 'configuration', view.widgets,
                                             list(view.fields.keys())[:-3],  # omit forests settings
                                             legend=_("Don't use default map configuration"),
                                             css_class='inner',
                                             switch=True,
                                             checkbox_switch=True,
                                             checkbox_field=IHuntingCalendarLocationMapPortletRendererSettings[
                                                 'no_use_default_map_configuration']))
            view.add_group(NamedWidgetsGroup(view, 'options', view.widgets,
                                             ('display_context_forests', 'set_bounds_to_forests'),
                                             legend=_("Display location forests"),
                                             css_class='inner',
                                             switch=True,
                                             checkbox_switch=True,
                                             checkbox_field=IHuntingCalendarLocationMapPortletRendererSettings[
                                                 'display_context_forests']))
            view.add_group(NamedWidgetsGroup(view, 'content_link', view.widgets,
                                             ('display_content_link', 'content_link_label'),
                                             legend=_("Display link to shared content"),
                                             css_class='inner',
                                             switch=True,
                                             checkbox_switch=True,
                                             checkbox_field=IHuntingCalendarLocationMapPortletRendererSettings[
                                                 'display_content_link']))
            AdminDialogEditForm.updateGroups(view)
