# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
import json

from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.search.skin.map import MapWithHeadFiltersSearchResultsPortletRenderer, \
    MapWithHeadFiltersSearchResultsPortletRendererSettings
from onf_website.reference.forest import Foret
from onf_website.reference.forest.model.foret import REG_ID_NAT_FRT
from onf_website.reference.insee.model import Commune, REG_COMMUNE_CODE
from onf_website.shared.hub.skin.search import ForestHubSearchFolderHeaderPortletRenderer
from onf_website.shared.hunting.interfaces import IHuntingCalendarSearchFolder
from onf_website.shared.hunting.skin.interfaces import IHuntingCalendarsMapSearchResultsPortletRendererSettings
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.features.search.portlet import ISearchResultsPortletSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(required=(IHuntingCalendarSearchFolder, IONFBaseLayer, Interface),
                provides=IPortletRenderer)
class HuntingCalendarSearchFolderHeaderPortletRenderer(ForestHubSearchFolderHeaderPortletRenderer):
    """Hunting calendar search folder header portlet renderer"""


#
# Hunting calendar search folder search results portlet renderer
#

@factory_config(IHuntingCalendarsMapSearchResultsPortletRendererSettings)
class HuntingCalendarsMapSearchResultsPortletRendererSettings(MapWithHeadFiltersSearchResultsPortletRendererSettings):
    """Hunting calendar search results portlet renderer settings"""

    display_header = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['display_header'])
    search_distance = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['search_distance'])
    display_distance = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['display_distance'])
    distance_message = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['distance_message'])
    short_distance_length = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['short_distance_length'])
    short_distance_message = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['short_distance_message'])
    no_result_message = FieldProperty(
        IHuntingCalendarsMapSearchResultsPortletRendererSettings['no_result_message'])

    allow_pagination = True

    def __int__(self):
        super().__init__()
        self.distance_message = {
            'en': "At {} from selected position",
            'fr': "À une distance de {}"
        }
        self.short_distance_message = {
            'en': "Within {}",
            'fr': "À moins de {}"
        }

    
@adapter_config(name='hunting-calendars-map',
                required=(IPortalContext, IPyAMSLayer, Interface, ISearchResultsPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/hunting-calendars-map.pt', layer=IPyAMSLayer)
class HuntingCalendarsMapSearchResultsPortletRenderer(MapWithHeadFiltersSearchResultsPortletRenderer):
    """Hunting calendar map search results portlet renderer"""
    
    label = _("ONF: Hunting calendars search results map")

    settings_interface = IHuntingCalendarsMapSearchResultsPortletRendererSettings
    weight = 85
    
    default_page_length = 20

    @property
    def values_map(self):
        user_search = self.request.params.get('user_search', '').strip()
        if user_search:
            if REG_ID_NAT_FRT.match(user_search.upper()):
                foret, info_foret = Foret.find_by_id(user_search.upper(), with_info=True).first()
                if foret is not None:
                    return json.dumps({
                        user_search: getattr(info_foret, 'libelle', None) or foret.title
                    })
            elif REG_COMMUNE_CODE.match(user_search):
                commune = Commune.get(user_search).first()
                if commune is not None:
                    return json.dumps({user_search: commune.title})
        return json.dumps({})
