#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from persistent import Persistent
from zope.interface import Interface
from zope.location import Location
from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.common.skin.head import BaseHeaderPortletRenderer
from onf_website.shared.common.skin.interfaces import IHubHeaderWithImagesPortletRendererSettings
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common.portlet.interfaces import ISharedContentHeaderPortletSettings
from pyams_file.property import FileProperty
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='ONF::head-hub',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head-hub.pt', layer=IONFBaseLayer)
class HubHeaderPortletRenderer(BaseHeaderPortletRenderer):
    """Hub header portlet renderer"""

    label = _("ONF: Hub header with text or banner")
    weight = 30


@factory_config(provided=IHubHeaderWithImagesPortletRendererSettings)
class HubHeaderWithImagesPortletRendererSettings(Persistent, Location):
    """Hub header portlet with images renderer settings"""

    background_image = FileProperty(
        IHubHeaderWithImagesPortletRendererSettings['background_image'])
    foreground_left_image = FileProperty(
        IHubHeaderWithImagesPortletRendererSettings['foreground_left_image'])
    foreground_right_image = FileProperty(
        IHubHeaderWithImagesPortletRendererSettings['foreground_right_image'])
    heading = FieldProperty(
        IHubHeaderWithImagesPortletRendererSettings['heading'])


@adapter_config(name='ONF::head-hub-images',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head-hub-images.pt', layer=IONFBaseLayer)
class HubHeaderWithImagesPortletRenderer(BaseHeaderPortletRenderer):
    """Hub header portlet renderer with """

    label = _("ONF: Hub header with text and custom images")
    weight = 40

    settings_interface = IHubHeaderWithImagesPortletRendererSettings
