#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.shared.hub.portlet import IForestHubsSearchResultsPortletSettings
from pyams_form.form import AJAXEditForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='properties.html',
                context=IForestHubsSearchResultsPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class ForestHubsSearchResultsPortletSettingsEditor(PortletSettingsEditor):
    """Forest hubs search results portlet settings editor"""

    settings = IForestHubsSearchResultsPortletSettings


@adapter_config(name='properties.json',
                context=(IForestHubsSearchResultsPortletSettings, IPyAMSLayer),
                provides=IPagelet)
class ForestHubsSearchResultsPortletSettingsAJAXEditor(
        AJAXEditForm, ForestHubsSearchResultsPortletSettingsEditor):
    """Forest hubs search results portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface,
                         IForestHubsSearchResultsPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/forest-hubs-preview.pt', layer=IPyAMSLayer)
class ForestHubsSearchResultsPortletPreviewer(PortletPreviewer):
    """Forest hubs search results portlet previewer"""
