#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.shared.furniture.interfaces import IFurnitureManager, IWfFurniture
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm
from pyams_content.shared.common.zmi.types import TypedSharedContentAddForm
from pyams_form.form import ajax_config
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(context=(IWfFurniture, IContentManagementMenu), provides=IMenuHeader)
class FurnitureContentMenuHeader(ContextRequestAdapter):
    """Furniture content menu header adapter"""

    header = _("This furniture")


@adapter_config(context=(IWfFurniture, IPyAMSLayer, Interface), provides=IContentTitle)
class FurnitureTitleAdapter(ContextRequestViewAdapter):
    """Furniture title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Furniture « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action',
                context=IFurnitureManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, weight=1,
                permission=CREATE_CONTENT_PERMISSION)
class FurnitureAddAction(ToolbarAction):
    """Furniture adding action"""

    label = _("Add furniture")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html',
                context=IFurnitureManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json',
             context=IFurnitureManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION,
             base=SharedContentAJAXAddForm)
class FurnitureAddForm(TypedSharedContentAddForm):
    """Furniture add form"""

    legend = _("Add furniture")
