#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.furniture.interfaces import IFurniture, IWfFurniture, IWfFurnitureFactory, \
    FURNITURE_CONTENT_NAME, FURNITURE_CONTENT_TYPE
from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ICollectionsTarget, ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@implementer(IWfFurniture, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget,
             IPreviewTarget, IReviewTarget)
class WfFurniture(WfSharedContent, WfTypedSharedContentMixin):
    """Furniture class"""

    content_type = FURNITURE_CONTENT_TYPE
    content_name = FURNITURE_CONTENT_NAME

    references = FieldProperty(IWfFurniture['references'])

register_content_type(WfFurniture)


@provider(IWfFurnitureFactory)
@implementer(IFurniture)
class Furniture(SharedContent):
    """Workflow managed furniture"""


@adapter_config(context=IWfFurnitureFactory, provides=IWfSharedContentFactory)
def furniture_content_factory(context):
    return WfFurniture
