#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form.interfaces import INPUT_MODE, ISingleCheckBoxWidget

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.form import IWfForm
from pyams_form.interfaces.form import ISelect2Widget
from pyams_form.widget import override_widget_template


__docformat__ = 'restructuredtext'


override_widget_template(widget=ISingleCheckBoxWidget,
                         template='templates/single-checkbox-input.pt',
                         context=IWfForm,
                         layer=IONFBaseLayer,
                         mode=INPUT_MODE)


override_widget_template(widget=ISelect2Widget,
                         template='templates/select-input.pt',
                         context=IWfForm,
                         layer=IONFBaseLayer,
                         mode=INPUT_MODE)
