#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form.browser.widget import HTMLFormElement
from z3c.form.interfaces import DISPLAY_MODE, INPUT_MODE, NO_VALUE
from z3c.form.widget import FieldWidget, MultiWidget
from zope.schema.vocabulary import getVocabularyRegistry

from onf_website.reference.forest.interfaces import FOREST_OWNERS_CATEGORIES
from pyams_form.interfaces import IFormLayer
from pyams_form.widget import widgettemplate_config
from pyams_portal.interfaces import PORTAL_TEMPLATES_VOCABULARY


@widgettemplate_config(mode=INPUT_MODE,
                       template='templates/templates-input.pt', layer=IFormLayer)
@widgettemplate_config(mode=DISPLAY_MODE,
                       template='templates/templates-display.pt', layer=IFormLayer)
class ForestManagerTemplatesSelectWidget(HTMLFormElement, MultiWidget):
    """Forest manager templates select widget"""

    @property
    def items(self):
        templates = self.field.bind(self.context).get(self.context) or {}
        vocabulary = getVocabularyRegistry().get(self.context, FOREST_OWNERS_CATEGORIES)
        for value, term in sorted(vocabulary.by_value.items(),
                                  key=lambda x: x[1].value):
            template = templates.get(value)
            yield term, template

    @property
    def templates(self):
        yield from sorted(getVocabularyRegistry().get(self.context,
                                                      PORTAL_TEMPLATES_VOCABULARY).by_value.items(),
                          key=lambda x: x[1].title)

    def updateWidgets(self):
        pass

    def extract(self, default=NO_VALUE):
        if self.request.get('{}_marker'.format(self.name)) is None:
            return default
        result = []
        vocabulary = getVocabularyRegistry().get(self.context, FOREST_OWNERS_CATEGORIES)
        for value, term in vocabulary.by_value.items():
            result.append([(value,),
                           (self.request.get('{}_{}'.format(self.name, value)) or
                            '--NOVALUE--',)])
        return result


def ForestManagerTemplatesSelectWidgetFactory(field, request):
    """Forest manager templates select widget factory"""
    return FieldWidget(field, ForestManagerTemplatesSelectWidget(request))
