#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from onf_website.reference.forest.model.interfaces.foret import StatutForetException
from onf_website.shared.common.skin.head import BaseHeaderPortletRenderer
from onf_website.shared.forest.interfaces import IForestManager
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.illustration.interfaces import IIllustration
from pyams_content.features.renderer.interfaces import HIDDEN_RENDERER_NAME
from pyams_content.shared.common.portlet.interfaces import ISharedContentHeaderPortletSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import query_utility

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='ONF::head-forest',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head-forest.pt', layer=IONFBaseLayer)
class ForestHeaderPortletRenderer(BaseHeaderPortletRenderer):
    """Forest header portlet renderer"""

    label = _("ONF: Forest header")
    weight = 70

    def get_exception_status(self):
        foret, proprietaire, info_foret = self.context.forest_refs[0]
        if (info_foret is None) or (info_foret.statut_exception == StatutForetException.f):
            return None
        if info_foret.statut_exception == StatutForetException.c:
            return 'candidate'
        return 'exception'

    def get_illustration(self):
        illustration = IIllustration(self.context, None)
        if (illustration is not None) and illustration.has_data():
            if illustration.renderer != HIDDEN_RENDERER_NAME:
                return illustration
        manager = query_utility(IForestManager)
        if manager is None:
            return None
        foret, proprietaire, info_foret = self.context.forest_refs[0]
        if foret.departement.startswith('97'):
            adapter_name = 'dom'
        else:
            adapter_name = ''
        illustration = self.request.registry.queryAdapter(manager, IIllustration,
                                                          name=adapter_name)
        if adapter_name and \
                ((illustration is None) or
                 (not illustration.has_data()) or
                 (illustration.renderer == HIDDEN_RENDERER_NAME)):
            illustration = self.request.registry.queryAdapter(manager, IIllustration,
                                                              name='')
        return illustration
