#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from onf_website.shared.forest.portlet import IBaselinePortletSettings
from pyams_form.form import AJAXEditForm
from pyams_form.interfaces.form import IInnerTabForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


__docformat__ = 'restructuredtext'


@pagelet_config(name='properties.html',
                context=IBaselinePortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class BaselinePortletSettingsEditor(PortletSettingsEditor):
    """Baseline portlet settings editor"""

    settings = IBaselinePortletSettings


@adapter_config(name='properties',
                context=(Interface, IPyAMSLayer, BaselinePortletSettingsEditor),
                provides=IInnerTabForm)
class BaselinePortletSettingsPropertiesEditor(PortletSettingsPropertiesEditor):
    """Baseline portlet settings properties editor"""


@adapter_config(name='properties.json',
                context=(IBaselinePortletSettings, IPyAMSLayer),
                provides=IPagelet)
class BaselinePortletAJAXEditor(AJAXEditForm, BaselinePortletSettingsEditor):
    """Baseline portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface, IBaselinePortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/baseline-preview.pt', layer=IPyAMSLayer)
class BaselinePortletPreviewer(PortletPreviewer):
    """Baseline portlet previewer"""
