#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.location.interfaces import ISublocations

from onf_website.shared.forest import IWfForest
from onf_website.shared.forest.interfaces import MANAGE_FOREST_PERMISSION
from pyams_content.component.gallery import GALLERY_CONTAINER_KEY, GalleryPermissionChecker, \
    IGallery
from pyams_content.shared.common import IWfSharedContent
from pyams_form.interfaces.form import IFormContextPermissionChecker
from pyams_utils.adapter import ContextAdapter, adapter_config, get_annotation_adapter
from pyams_utils.registry import get_global_registry
from pyams_utils.traversing import get_parent
from pyams_workflow.interfaces import IWorkflow, IWorkflowState


@adapter_config(name='draft',
                context=IWfForest,
                provides=IGallery)
def forest_draft_gallery_factory(forest):
    """Forest draft gallery target"""
    return get_annotation_adapter(forest,
                                  '{}::draft'.format(GALLERY_CONTAINER_KEY), IGallery,
                                  name='++gallery++draft')


@adapter_config(context=IGallery,
                provides=IFormContextPermissionChecker)
class DraftGalleryPermissionChecker(GalleryPermissionChecker):
    """Draft gallery permission checker"""

    @property
    def edit_permission(self):
        gallery = get_parent(self.context, IGallery)
        if gallery.__name__ == '++gallery++draft':
            content = get_parent(self.context, IWfSharedContent)
            workflow = IWorkflow(content)
            state = IWorkflowState(content)
            if state.state not in workflow.published_states | workflow.archived_states:
                return MANAGE_FOREST_PERMISSION
        return super().edit_permission


@adapter_config(name='gallery-draft',
                context=IWfForest,
                provides=ISublocations)
class ForestDraftGallerySublocation(ContextAdapter):
    """Forest draft gallery sub-location"""

    def sublocations(self):
        registry = get_global_registry()
        return registry.getAdapter(self.context, IGallery, name='draft').values()
