#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.shared.expengine.interfaces import EXPENGINE_CONTENT_TYPE, IExpEngineManager, IExpEngineManagerFactory
from pyams_content.shared.common.interfaces import ISharedContentFactory
from zope.annotation.interfaces import IAttributeAnnotatable
from zope.component.interfaces import ISite
from zope.lifecycleevent.interfaces import IObjectAddedEvent

# import packages
from onf_website.shared.expengine import ExpEngine
from pyams_content.shared.common.manager import SharedTool
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent
from pyramid.events import subscriber
from zope.interface import implementer, provider


@implementer(IExpEngineManager, IAttributeAnnotatable)
class ExpEngineManager(SharedTool):
    """Experiential engine manager class"""

    shared_content_type = EXPENGINE_CONTENT_TYPE
    shared_content_menu = False


@utility_config(provides=IExpEngineManagerFactory)
class ExpEngineManagerFactory(object):
    """Default experiential engine manager factory"""

    def __new__(cls):
        return ExpEngineManager


@adapter_config(context=IExpEngineManager, provides=ISharedContentFactory)
def expengine_manager_content_factory(context):
    """Experiential engine manager content factory"""
    return ExpEngine


@subscriber(IObjectAddedEvent, context_selector=IExpEngineManager)
def handle_added_expengine_manager(event):
    """Register experiential engine manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IExpEngineManager)
