#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Attribute, Interface

from onf_website import _
from pyams_content.features.menu.interfaces import IMenusContainer
from pyams_content.shared.common.interfaces import ISharedContent, ISharedTool, IWfSharedContent
from pyams_i18n.schema import I18nTextLineField


EXPENGINE_CONTENT_TYPE = 'search.expengine'
EXPENGINE_CONTENT_NAME = _("Experiential engine")


class IExpEngineManager(ISharedTool):
    """Experiential engine manager interface"""


class IExpEngineManagerFactory(Interface):
    """Experiential engine manager factory interface"""


class IWfExpEngineInfo(Interface):
    """Experiential engine attributes interface"""

    first_menu_leading = I18nTextLineField(title=_("First menu leading"),
                                           description=_("Leading associated with first menu options"),
                                           required=False)

    second_menu_leading = I18nTextLineField(title=_("Second menu leading"),
                                            description=_("Leading associated with second menu options"),
                                            required=False)

    menus = Attribute("Navigation menus")


class IWfExpEngine(IWfSharedContent, IWfExpEngineInfo):
    """Experiential engine interface"""


class IWfExpEngineFactory(Interface):
    """Experiential engine factory interface"""


class IExpEngine(ISharedContent):
    """Workflow manager experiential engine interface"""


class IExpEngineMenusContainer(IMenusContainer):
    """Experiential engine menus container"""
