#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.response import Response
from pyramid.view import view_config
from zope.contentprovider.interfaces import IContentProvider

from onf_website.shared.contact.interfaces.theme import IContactTheme, IContactThemeManager
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer, IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.list import boolean_iter
from pyams_utils.text import text_to_html
from pyams_viewlet.viewlet import BaseContentProvider


__docformat__ = 'restructuredtext'


@adapter_config(context=(IContactTheme, IPyAMSUserLayer), provides=IContentProvider,
                name='theme-info')
@template_config(template='templates/theme-info.pt', layer=IPyAMSUserLayer)
class ContactThemeFieldSuffix(BaseContentProvider):
    """Contact theme field suffix"""

    def get_theme_links(self):
        viewlet = self.request.registry.queryMultiAdapter((self.context, self.request, self),
                                                          IContentProvider, name='pyams.associations')
        if viewlet is not None:
            has_links, associations = boolean_iter(viewlet.get_associations())
            if has_links:
                viewlet.update()
                teaser = II18n(self.context).query_attribute('teaser', request=self.request)
                if teaser:
                    yield '<p>{0}</p>'.format(text_to_html(teaser))
                yield viewlet.render()


@view_config(name='get-theme-infos.html', context=IContactThemeManager, request_type=IPyAMSLayer)
def get_theme_infos(request):
    """Get theme infos"""
    name = request.params.get('value')
    if (not name) or (name == '--NOVALUE--'):
        return Response('')
    theme = request.context.get(name)
    registry = request.registry
    content = registry.queryMultiAdapter((theme, request), IContentProvider,
                                         name='theme-info')
    if content is not None:
        content.update()
        return Response(content.render())
