#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.schema import Choice

from onf_website.shared.contact.interfaces.field import CONTACT_FORM_THEMES_FIELD_VALUES_VOCABULARY
from pyams_content.component.links.interfaces import ICustomInternalLinkTarget, \
    IInternalLinkCustomInfo


__docformat__ = 'restructuredtext'

from onf_website import _


class IInternalFormLinkTarget(ICustomInternalLinkTarget):
    """Internal link to form marker interface"""


INTERNAL_FORM_LINK_PROPERTIES_KEY = 'onf_website.internal_link.form'


class IInternalFormLinkTheme(IInternalLinkCustomInfo):
    """Theme pre-selection on internal link to form"""

    selected_theme = Choice(title=_("Pre-selected theme"),
                            description=_("If a theme is selected here, it will be automatically "
                                          "selected in the target form"),
                            vocabulary=CONTACT_FORM_THEMES_FIELD_VALUES_VOCABULARY,
                            required=False)
