#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface, Attribute
from zope.schema import TextLine, URI

from pyams_content.shared.common.interfaces import ISharedContent, IWfSharedContent, ISharedTool
from pyams_i18n.schema import I18nTextLineField
from pyams_utils.schema import MailAddressField

from onf_website import _


CONTACT_CONTENT_TYPE = 'contact'
CONTACT_CONTENT_NAME = _("Contact")


class IContactManager(ISharedTool):
    """Contacts manager interface"""

    def get_contacts(self, theme):
        """Get active contacts for givne theme"""

    def get_contacts_matching(self, theme, insee_code=None, dept_code=None):
        """Get active contacts matching given theme and INSEE code"""


class IContactManagerFactory(Interface):
    """Contact manager factory interface"""


class IWfContactInfo(Interface):
    """Contact custom attributes interface"""

    contact_name = TextLine(title=_("Contact name"),
                            description=_("Full contact name"),
                            required=False)

    target_url = URI(title=_("Target URI"),
                     description=_("This URI will be displayed in contact form if this "
                                   "assignment is matching location and theme"),
                     required=False)

    target_url_label = I18nTextLineField(title=_("Target URI label"),
                                         description=_("This is the label which will be associated "
                                                       "with the given URI"),
                                         required=False)

    mail_address = MailAddressField(title=_("Mail address"),
                                    description=_("Strict email address, without '<' or '>'"),
                                    required=False)

    phone_number = TextLine(title=_("Phone number"),
                            description=_('Phone number in international format.\n E.g. +33 ....'),
                            required=False)

    assignments = Attribute("Contact assignments")

    def get_active_assignments(self):
        """Get current active assignments"""


class IWfContact(IWfSharedContent, IWfContactInfo):
    """Contact interface"""


class IWfContactFactory(Interface):
    """Contact factory interface"""


class IContact(ISharedContent):
    """Workflow managed contact interface"""
