#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import classImplements
from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.contact.interfaces.form import IInternalFormLinkTarget, \
    IInternalFormLinkTheme, INTERNAL_FORM_LINK_PROPERTIES_KEY
from pyams_content.component.links import IInternalLinkCustomInfoTarget
from pyams_content.component.links.interfaces import IInternalLinkCustomInfo
from pyams_content.shared.form import IWfForm, WfForm
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'

classImplements(WfForm, IInternalLinkCustomInfoTarget)
WfForm.internal_link_marker_interface = IInternalFormLinkTarget


@factory_config(provided=IInternalFormLinkTheme)
class InternalFormLinkTheme(Persistent, Contained):
    """internal link to form additional properties"""

    properties_interface = IInternalFormLinkTheme

    selected_theme = FieldProperty(IInternalFormLinkTheme['selected_theme'])

    def get_url_params(self):
        if self.selected_theme:
            return {'theme': self.selected_theme}


@adapter_config(context=IInternalFormLinkTarget, provides=IInternalLinkCustomInfo)
@adapter_config(context=IInternalFormLinkTarget, provides=IInternalFormLinkTheme)
def internal_form_link_info_adapter(context):
    """Internal link to form adapter"""
    target = context.target
    if not IWfForm.providedBy(target):
        return None
    return get_annotation_adapter(context, INTERNAL_FORM_LINK_PROPERTIES_KEY,
                                  IInternalFormLinkTheme)
