#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.contact.interfaces import CONTACT_CONTENT_NAME, CONTACT_CONTENT_TYPE, \
    IContact, IContactManager, IWfContact, IWfContactFactory
from onf_website.shared.contact.interfaces.assignment import CONTACT_ASSIGNMENTS_ANNOTATION_KEY, \
    IContactAssignment, IContactAssignmentsContainer
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, \
    register_content_type
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


#
# Contact persistent class
#

@implementer(IWfContact)
class WfContact(WfSharedContent):
    """Base contact class"""

    content_type = CONTACT_CONTENT_TYPE
    content_name = CONTACT_CONTENT_NAME

    handle_content_url = False
    handle_header = False
    handle_description = False

    contact_name = FieldProperty(IWfContact['contact_name'])
    target_url = FieldProperty(IWfContact['target_url'])
    target_url_label = FieldProperty(IWfContact['target_url_label'])
    mail_address = FieldProperty(IWfContact['mail_address'])
    phone_number = FieldProperty(IWfContact['phone_number'])

    @property
    def assignments(self):
        return IContactAssignmentsContainer(self, None)

    def get_active_assignments(self):
        yield from IContactAssignmentsContainer(self).get_active_assignments()


register_content_type(WfContact, shared_content=False)


@provider(IWfContactFactory)
@implementer(IContact)
class Contact(SharedContent):
    """Workflow managed contact class"""


@adapter_config(context=IWfContactFactory, provides=IWfSharedContentFactory)
def contact_content_factory(context):
    return WfContact
