#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.component.location import ILocationManagerTarget
from pyams_content.shared.common.interfaces import IManagerRestrictions
from pyams_skin.table import I18nColumn
from pyams_zmi.layer import IAdminLayer
from z3c.table.interfaces import IColumn

# import packages
from pyams_content.shared.common.zmi.security import SharedToolManagersRestrictionsTable
from pyams_utils.adapter import adapter_config
from z3c.table.column import GetAttrColumn

from onf_website import _


@adapter_config(name='countries', context=(ILocationManagerTarget, IAdminLayer, SharedToolManagersRestrictionsTable),
                provides=IColumn)
class SharedToolManagerRestrictionsCountriesColumn(I18nColumn, GetAttrColumn):
    """Shared tool manager countries restrictions column"""

    _header = _("Countries")
    weight = 60
    cssClasses = {'td': 'center'}

    def getValue(self, obj):
        restrictions = IManagerRestrictions(self.context).get_restrictions(obj)
        if (restrictions is not None) and restrictions.restricted_contents and restrictions.countries:
            return '<i class="fa fa-fw fa-check"></i>'
        else:
            return '--'


@adapter_config(name='departments', context=(ILocationManagerTarget, IAdminLayer, SharedToolManagersRestrictionsTable),
                provides=IColumn)
class SharedToolManagerRestrictionsDepartmentsColumn(I18nColumn, GetAttrColumn):
    """Shared tool manager departments restrictions column"""

    _header = _("Departments")
    weight = 62
    cssClasses = {'td': 'center'}

    def getValue(self, obj):
        restrictions = IManagerRestrictions(self.context).get_restrictions(obj)
        if (restrictions is not None) and restrictions.restricted_contents and restrictions.departments:
            return '<i class="fa fa-fw fa-check"></i>'
        else:
            return '--'


@adapter_config(name='structures', context=(ILocationManagerTarget, IAdminLayer, SharedToolManagersRestrictionsTable),
                provides=IColumn)
class SharedToolManagerRestrictionsStructuresColumn(I18nColumn, GetAttrColumn):
    """Shared tool manager structures restrictions column"""

    _header = _("Structures")
    weight = 64
    cssClasses = {'td': 'center'}

    def getValue(self, obj):
        restrictions = IManagerRestrictions(self.context).get_restrictions(obj)
        if (restrictions is not None) and restrictions.restricted_contents and restrictions.structures:
            return '<i class="fa fa-fw fa-check"></i>'
        else:
            return '--'


@adapter_config(name='forests', context=(ILocationManagerTarget, IAdminLayer, SharedToolManagersRestrictionsTable),
                provides=IColumn)
class SharedToolManagerRestrictionsForestsColumn(I18nColumn, GetAttrColumn):
    """Shared tool manager forests restrictions column"""

    _header = _("Forests")
    weight = 66
    cssClasses = {'td': 'center'}

    def getValue(self, obj):
        restrictions = IManagerRestrictions(self.context).get_restrictions(obj)
        if (restrictions is not None) and restrictions.restricted_contents and restrictions.forests:
            return '<i class="fa fa-fw fa-check"></i>'
        else:
            return '--'
