#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_default_theme.shared.common.portlet.workflow import \
    SharedContentPublicationDataProvider
from pyams_viewlet.viewlet import contentprovider_config


__docformat__ = 'restructuredtext'


@contentprovider_config(name='pyams_content.publication_date', layer=IONFBaseLayer,
                        view=Interface)
class ONFSharedContentPublicationDataProvider(SharedContentPublicationDataProvider):
    """Shared content publication date viewlet"""

    date_format = 'short'
