#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.component.hearing import IHearingInfo
from pyams_content.shared.common.interfaces import IWfSharedContent
from pyams_content.shared.common.interfaces.types import IWfTypedSharedContent
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, adapter_config
from pyams_utils.interfaces.url import ICanonicalURL
from pyams_utils.url import absolute_url


@adapter_config(context=(IWfSharedContent, IPyAMSUserLayer), provides=ICanonicalURL)
class WfSharedContentCanonicalURL(ContextRequestAdapter):
    """Shared content canonical URL"""

    def get_url(self, view_name=None, query=None):
        parent = None
        hearing = IHearingInfo(self.context, None)
        if hearing is not None:
            parent = hearing.get_source_folder()
            if parent is None:
                parent = hearing.get_source_site()
        if parent is None:
            parent = self.request.root
        return absolute_url(parent, self.request,
                            '+/{0}::{1}.html'.format(
                                ISequentialIdInfo(self.context).get_base_oid().strip(),
                                self.context.content_url), query)


@adapter_config(context=(IWfTypedSharedContent, IPyAMSUserLayer), provides=ICanonicalURL)
class WfTypedSharedContentCanonicalURL(ContextRequestAdapter):
    """Typed shared content canonical URL"""

    def get_url(self, view_name=None, query=None):
        parent = None
        hearing = IHearingInfo(self.context, None)
        if hearing is not None:
            parent = hearing.get_source_folder()
            if parent is None:
                parent = hearing.get_source_site()
        if parent is None:
            data_type = self.context.get_data_type()
            if data_type is not None:
                parent = data_type.get_source_folder()
        if parent is None:
            parent = self.request.root
        return absolute_url(parent, self.request,
                            '+/{0}::{1}.html'.format(
                                ISequentialIdInfo(self.context).get_base_oid().strip(),
                                self.context.content_url))
