#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public import aside_sticky
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common.portlet.interfaces import ISharedContentTitlePortletSettings
from pyams_default_theme.shared.common.portlet.title import SharedContentTitlePortletRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@adapter_config(context=(IPortalContext, IONFBaseLayer, Interface,
                         ISharedContentTitlePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/title.pt', layer=IPyAMSLayer)
class ONFSharedContentTitlePortletRenderer(SharedContentTitlePortletRenderer):
    """Custom shared content title portlet renderer template"""

    resources = (aside_sticky,)
