#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_website.shared.common.skin card module

"""

from zope.interface import Interface

from onf_website.shared.common.skin.interfaces import IContentCard
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common import IWfSharedContent
from pyams_template.template import template_config
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension
from pyams_utils.url import canonical_url, relative_url
from pyams_viewlet.viewlet import ViewContentProvider


__docformat__ = 'restructuredtext'


@adapter_config(context=(IWfSharedContent, IONFBaseLayer, Interface),
                provides=IContentCard)
@template_config(template='templates/card.pt', layer=IONFBaseLayer)
class SharedContentCard(ViewContentProvider):
    """Generic hared content card"""

    css_class = 'card card--light'
    card_class = ''
    pic_class = 'card__pic'
    force_canonical_url = False
    xs_thumb = 'pano'
    xs_width = 12
    sm_thumb = 'pano'
    sm_width = 12
    md_thumb = 'pano'
    md_width = 6
    lg_thumb = 'pano'
    lg_width = 6
    img_class = 'card__img'
    detail_class = 'card__detail'
    show_tag = True
    tag_class = 'card__tag'
    title_class = 'card__title'
    title_length = -1
    head_class = 'card__excerpt'
    head_length = -1

    def update(self, **kwargs):
        super(SharedContentCard, self).update()
        self.__dict__.update(**kwargs)

    @property
    def target_url(self):
        if self.force_canonical_url:
            return canonical_url(self.context, self.request)
        return relative_url(self.context, self.request)


@adapter_config(name='onf.card',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class ContentCardTalesExtension(ContextRequestViewAdapter):
    """Content card TALES extension"""

    def render(self, context=None, *args, **kwargs):
        if context is None:
            context = self.context
        name = kwargs.get('name', '')
        card = self.request.registry.queryMultiAdapter((context, self.request, self.view),
                                                       IContentCard, name=name)
        if name and (card is None):
            card = self.request.registry.queryMultiAdapter((context, self.request, self.view),
                                                           IContentCard)
        if card is not None:
            card.update(*args, **kwargs)
            return card.render()
        return ''
