#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website import _
from pyams_content.shared.common.interfaces import ISharedContent, ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_content.shared.logo import LOGO_CONTENT_TYPE
from pyams_sequence.interfaces import IInternalReferencesList
from pyams_sequence.schema import InternalReferencesListField


CASE_STUDY_CONTENT_TYPE = 'case-study'
CASE_STUDY_CONTENT_NAME = _("Case study")


class ICaseStudyManager(ISharedToolPortalContext):
    """Use-case manager interface"""


class ICaseStudyManagerFactory(Interface):
    """Use-case manager factory interface"""


class IWfCaseStudyInfo(Interface):
    """Use-case custom attributes interface"""

    logos = InternalReferencesListField(title=_("Clients logos"),
                                        description=_("Logos list of partners who where concerned in this use "
                                                      "case"),
                                        content_type=LOGO_CONTENT_TYPE,
                                        required=False)

    def get_logos(self, state=None):
        """Get logos from internal references"""


class IWfCaseStudy(IWfSharedContentPortalContext, IWfCaseStudyInfo, IInternalReferencesList):
    """Use-case interface"""


class IWfCaseStudyFactory(Interface):
    """Use-case parent interface"""


class ICaseStudy(ISharedContent):
    """Workflow managed use-case interface"""
