#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import classImplements

from onf_website.component.hearing import IHearingTarget
from onf_website.component.hearing.interfaces import IHearingManagerTarget
from onf_website.component.location import ILocationManagerTarget, ILocationTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.alert import WfAlert
from pyams_content.shared.alert.interfaces import IAlertsManager
from pyams_content.shared.alert.manager import AlertsManager
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


classImplements(AlertsManager, ILocationManagerTarget)
classImplements(AlertsManager, IHearingManagerTarget)

classImplements(WfAlert, ILocationTarget)
classImplements(WfAlert, IHearingTarget)


@adapter_config(required=IAlertsManager,
                provides=IManagerRestrictionsFactory)
def alerts_manager_restrictions_factory(context):
    """Alerts manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo
