#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from onf_website.shared.activity import IWfActivity
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.gallery import IBaseGallery
from pyams_content.component.illustration import IBasicIllustration
from pyams_default_theme.component.illustration import base_content_banner_illustration_factory, \
    base_content_navigation_illustration_factory
from pyams_default_theme.interfaces import IContentBannerIllustration, \
    IContentNavigationIllustration
from pyams_utils.adapter import adapter_config


@adapter_config(context=(IWfActivity, IONFBaseLayer),
                provides=IContentBannerIllustration)
def activity_banner_illustration_adapter(context, request):
    """Activity banner illustration adapter"""
    illustration = base_content_banner_illustration_factory(context, request)
    if not (illustration and illustration.has_data()):
        gallery = IBaseGallery(context, None)
        if gallery is not None:
            illustration = IBasicIllustration(gallery, None)
    return illustration


@adapter_config(context=(IWfActivity, IONFBaseLayer),
                provides=IContentNavigationIllustration)
def activity_navigation_illustration_adapter(context, request):
    """Activity navigation illustration adapter"""
    illustration = base_content_navigation_illustration_factory(context, request)
    if not (illustration and illustration.has_data()):
        gallery = IBaseGallery(context, None)
        if gallery is not None:
            illustration = IBasicIllustration(gallery, None)
    return illustration
