#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing.interfaces import IHearingManagerTarget
from onf_website.component.location import ILocationManagerTarget
from onf_website.shared.activity import Activity, IActivityInfo
from onf_website.shared.activity.interfaces import ACTIVITY_CONTENT_TYPE, IActivityManager, \
    IActivityManagerFactory
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.component.paragraph import IParagraphFactorySettings
from pyams_content.component.theme import IThemesManagerTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory, \
    ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.common.types import TypedSharedToolMixin
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


@implementer(IActivityManager, IParagraphFactorySettings, ILocationManagerTarget,
             IHearingManagerTarget, IPictogramManagerTarget, IThemesManagerTarget)
class ActivityManager(SharedTool, TypedSharedToolMixin):
    """Activity manager class"""

    shared_content_type = ACTIVITY_CONTENT_TYPE

    shared_content_types_fields = IActivityInfo

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])

    adaptations_themes = FieldProperty(IActivityManager['adaptations_themes'])
    foretmapper_adaptations_themes = FieldProperty(IActivityManager['foretmapper_adaptations_themes'])
    default_hearing_source = FieldProperty(IActivityManager['default_hearing_source'])
    default_source_folder = FieldProperty(IActivityManager['default_source_folder'])
    infos_renderers = FieldProperty(IActivityManager['infos_renderers'])
    fixed_renderers_count = FieldProperty(IActivityManager['fixed_renderers_count'])


@utility_config(provides=IActivityManagerFactory)
class ActivityManagerFactory:
    """Activity manager factory"""

    def __new__(cls):
        return ActivityManager


@adapter_config(context=IActivityManager, provides=IManagerRestrictionsFactory)
def activity_manager_restrictions_factory(context):
    """Activity manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo


@adapter_config(context=IActivityManager, provides=ISharedContentFactory)
def activity_manager_content_factory(context):
    return Activity


@subscriber(IObjectAddedEvent, context_selector=IActivityManager)
def handle_added_activity_manager(event):
    """Register activity manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IActivityManager)
