#
# -*- encoding: utf-8 -*-
#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import classImplements

from onf_website.root.interfaces import ISiteRootToolsConfiguration
from pyams_content.component.gallery import IGalleryTarget
from pyams_content.root import ISiteRoot, SITEROOT_TOOLS_CONFIGURATION_KEY, \
    SiteRoot, SiteRootToolsConfiguration as SiteRootToolsConfigurationBase
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


classImplements(SiteRoot, IGalleryTarget)


#
# Tools configuration
#

@factory_config(ISiteRootToolsConfiguration)
class SiteRootToolsConfiguration(SiteRootToolsConfigurationBase):
    """Site root tools configuration"""

    country_table_name = None
    region_table_name = None
    department_table_name = None
    territory_table_name = None
    agency_table_name = None
    unit_table_name = None
    target_table_name = None

    resources_tool_name = None
    reports_tool_name = None
    interviews_tool_name = None
    expengines_tool_name = None
    longreads_tool_name = None
    activities_tool_name = None
    casestudies_tool_name = None
    services_tool_name = None
    press_tool_name = None
    contacts_tool_name = None
    hunting_tool_name = None
    forests_tool_name = None
    reserves_tool_name = None
    furniture_tool_name = None


@adapter_config(context=ISiteRoot, provides=ISiteRootToolsConfiguration)
def site_root_tools_configuration_factory(context):
    """Site root tools configuration factory"""
    return get_annotation_adapter(context, SITEROOT_TOOLS_CONFIGURATION_KEY,
                                  ISiteRootToolsConfiguration)
