#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.container.constraints import containers

from pyams_content.reference.interfaces import IReferenceInfo, IReferenceTable
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField

__docformat__ = 'restructuredtext'

from onf_website import _


class IUniverse(IReferenceInfo):
    """Universe interface"""

    containers('.IUniverseTable')
    
    title = I18nTextLineField(
            title=_("Title"),
            description=_("Title displayed above the universe dropdown menu"),
            required=True)
    
    description = I18nTextField(
            title=_("Description"),
            description=_("Text description or detailed information"),
            required=False)
    
    contact_target = InternalReferenceField(
            title=_("Contact link target"),
            description=_("Internal content displaying contact information"),
            required=False)


class IUniverseTable(IReferenceTable):
    """Interface for the Universe table."""
    
    dropdown_menu_title = I18nTextLineField(
            title=_("Dropdown menu title"),
            description=_("Label positioned in the universe dropdown menu"),
            required=False)
    
    inactive_info_title = I18nTextLineField(
            title=_("Inactive mode information title"),
            description=_("Title for inactive info"),
            required=False)
    
    inactive_info_text = I18nTextField(
            title=_("Inactive mode information text"),
            description=_("Text for inactive info"),
            required=False)
    
    online_help_title = I18nTextLineField(
            title=_("Online help block title"),
            description=_("Title for online help"),
            required=False)
    
    online_help_text = I18nTextField(
            title=_("Online help block text"),
            description=_("Text for online help"),
            required=False)
